// priority: 50

// 1. UI元素的位置 (对齐与坐标):
//    - 所有文本现在都设置为右对齐 (`alignX: "right"`) 并底部对齐 (`alignY: "bottom"`).
//    - 在 `信息` 函数的开头，有几个新的可配置变量来控制位置：
//        - `信息X坐标`: 控制整个UI块距离屏幕右边缘的像素值。
//          例如, `信息X坐标 = -10;` 表示UI距离屏幕右边缘10像素。
//        - `信息Y坐标`: 这是结算信息第4行(如果存在)底部的目标Y坐标。
//          `y`为负值表示向上移动。此值需要您根据饱食度条的实际位置进行微调。
//          例如, `信息Y坐标 = -35;` (一个初始估计值)。
//        - `行高偏移`: 控制多行文本之间底部基线的垂直距离 (未缩放前)。
//          例如, `行高偏移 = 15;`
//        - `DPS与结算间距`: 控制DPS行与结算信息第一行之间的额外向上距离。
//          例如, `DPS与结算间距 = 5;`
//
// 2. UI元素的文本大小 (缩放):
//    - 在 `信息` 函数的开头，`文本缩放 = 1.15;` 控制所有文本。 // 您已修改为1.15
// 
// 3. UI元素的文本颜色:
//    - 在 `信息` 函数中，为每个UI元素ID指定了 `color`。
//    - DPS: 青色 `"#00AAAA"`
//    - 结算 第1行: 蓝色 `"#5555FF"` 
//    - 结算 第2行: 亮绿色 `"#55FF55"`
//    - 结算 第3行: 黄色 `"#FFFF55"`
//    - 结算 第4行: 红色 `"#FF5555"`
//
// 4. 结算信息的自动关闭时间:
//    - 在 `处理最终伤害统计数据` 函数中，`Utils.server.scheduleInTicks(100, ...)`。
//    - `100` ticks = 5 秒。

let 伤害统计调试开关 = false;
let 会话超时时间_刻 = 3; // 3秒
let 全局会话数据 = {};

let 开关状态 = (p) => {
    if (!p || !p.persistentData || typeof p.persistentData.getBoolean !== "function") {
        return false;
    }
    let pDATA = p.persistentData;
    return pDATA.getBoolean("showDamageStats");
};

let 实体 = (维度ID, 实体UUID) => {
    if (!维度ID || !实体UUID) return null;
    let 世界 = Utils.server.getLevel(维度ID);
    if (世界) return 世界.getEntity(实体UUID);
    return null;
};

let 信息 = (玩家UUID, 消息内容, 消息类型) => {
    let 玩家列表 = [];
    let 玩家查找 = null;
    let 会话数据 = 全局会话数据[玩家UUID];

    if (消息类型 === "dps_clear" || 消息类型 === "summary_clear") {
        if (会话数据 && 会话数据.假人会话) {
            let 假人 = 实体(会话数据.维度ID, 玩家UUID);
            if (假人 && 假人.level && typeof 假人.level.getEntitiesWithin === "function") {
                let 附近通知半径 = 8.0;
                let 扫描包围盒 = 假人.getBoundingBox().inflate(附近通知半径);
                let 全部实体列表 = 假人.level.getEntitiesWithin(扫描包围盒);
                if (全部实体列表 && typeof 全部实体列表.filter === "function") {
                    全部实体列表.filter(实体 => 实体.isPlayer && typeof 实体.isPlayer === "function" && 实体.isPlayer()).forEach(临玩家 => {
                        if (!玩家列表.some(p => p.stringUuid === 临玩家.stringUuid)) {
                            玩家列表.push(临玩家);
                        }
                    });
                }
            }
            if (会话数据.锁定攻击者信息 && 会话数据.锁定攻击者信息.类型 === "玩家" && 会话数据.锁定攻击者信息.UUID) {
                let 攻击者p = Utils.server.getPlayer(会话数据.锁定攻击者信息.UUID);
                if (攻击者p && !玩家列表.some(plr => plr.stringUuid === 攻击者p.stringUuid)) {
                    玩家列表.push(攻击者p);
                }
            }
        } else {
            玩家查找 = 玩家UUID;
            let 攻击p = Utils.server.getPlayer(玩家查找);
            if (攻击p && 攻击p.level && typeof 攻击p.level.getEntitiesWithin === "function") {
                let 附近通知半径 = 8.0;
                let 扫描包围盒 = 攻击p.getBoundingBox().inflate(附近通知半径);
                攻击p.level.getEntitiesWithin(扫描包围盒)
                    .filter(实体 => 实体.isPlayer && typeof 实体.isPlayer === "function" && 实体.isPlayer() && 实体.stringUuid !== 玩家查找)
                    .forEach(临玩家 => {
                        if (!玩家列表.some(p => p.stringUuid === 临玩家.stringUuid)) {
                            玩家列表.push(临玩家);
                        }
                    });
            }
        }
    } else {
        if (!会话数据) return;

        if (!会话数据.假人会话) {
            玩家查找 = 玩家UUID;
            let 攻击p = Utils.server.getPlayer(玩家查找);
            if (攻击p && 攻击p.level && typeof 攻击p.level.getEntitiesWithin === "function") {
                let 附近通知半径 = 8.0;
                let 扫描包围盒 = 攻击p.getBoundingBox().inflate(附近通知半径);
                攻击p.level.getEntitiesWithin(扫描包围盒)
                    .filter(实体 => 实体.isPlayer && typeof 实体.isPlayer === "function" && 实体.isPlayer() && 实体.stringUuid !== 玩家查找)
                    .forEach(临玩家 => {
                        if (!玩家列表.some(p => p.stringUuid === 临玩家.stringUuid)) {
                            玩家列表.push(临玩家);
                        }
                    });
            }
        } else {
            if (会话数据.锁定攻击者信息 && 会话数据.锁定攻击者信息.类型 === "玩家") {
                玩家查找 = 会话数据.锁定攻击者信息.UUID;
            }
            let 假人 = 实体(会话数据.维度ID, 玩家UUID);
            if (假人 && 假人.level && typeof 假人.level.getEntitiesWithin === "function") {
                let 附近通知半径 = 8.0;
                let 扫描包围盒 = 假人.getBoundingBox().inflate(附近通知半径);
                let 全部实体列表 = 假人.level.getEntitiesWithin(扫描包围盒);
                if (全部实体列表 && typeof 全部实体列表.filter === "function") {
                    全部实体列表.filter(实体 => 实体.isPlayer && typeof 实体.isPlayer === "function" && 实体.isPlayer()).forEach(临玩家 => {
                        if (!玩家列表.some(p => p.stringUuid === 临玩家.stringUuid)) {
                            玩家列表.push(临玩家);
                        }
                    });
                }
            }
        }
    }

    if (玩家查找) {
        let p = Utils.server.getPlayer(玩家查找);
        if (p && !玩家列表.some(pl => pl.stringUuid === p.stringUuid)) {
            玩家列表.push(p);
        }
    }
    
    let 指定玩家 = [];
    if (玩家列表.length > 0) {
        let 玩家UUID集合 = new Set();
        玩家列表.forEach(p => {
            if (p && typeof p.getUuid === "function" && !玩家UUID集合.has(p.getUuid().toString())) {
                玩家UUID集合.add(p.getUuid().toString());
                指定玩家.push(p);
            }
        });
    }

    if (指定玩家.length === 0) return;

    for (let i = 0; i < 指定玩家.length; i++) {
        let 目标p = 指定玩家[i];
        if (!目标p || !目标p.name || typeof 目标p.name.string === "undefined") continue;
        if (消息类型 !== "dps_clear" && 消息类型 !== "summary_clear" && !开关状态(目标p)) continue;

        let 绘制 = {};
        let 文本缩放 = 1.1;
        let 信息X坐标 = -1;
        let 信息Y坐标 = -45;
        let 行高偏移 = 12;
        let DPS与结算间距 = 2;

        if (消息类型 === "dps") {
            let 文本内容 = "DPS错误";
            if (消息内容 && typeof 消息内容.getString === "function") {
                文本内容 = 消息内容.getString().replace(/§[0-9a-fk-or]/ig, "");
            } else if (typeof 消息内容 === "string") {
                文本内容 = 消息内容.replace(/§[0-9a-fk-or]/ig, "");
            }
            绘制["damage_dps_text"] = {
                type: "text", text: 文本内容, visible: true,
                alignX: "right", alignY: "bottom",
                x: 信息X坐标, y: 信息Y坐标 - (3 * 行高偏移) - 行高偏移 - DPS与结算间距,
                scale: 文本缩放, color: "#00FFFF", shadow: true, draw: "ingame"
            };
        } else if (消息类型 === "dps_clear") {
            绘制["damage_dps_text"] = { type: "text", visible: false, shadow: false };
        } else if (消息类型 === "summary" && Array.isArray(消息内容)) {
            let 行文本数组 = 消息内容;
            let 结算颜色表 = ["#FFFF55", "#55FF55", "#FFFF55", "#00FFFF"];
            let 有效行数 = 0;
            for (let j = 0; j < 行文本数组.length && j < 4; j++) {
                if ((行文本数组[j] || "").trim() !== "") 有效行数++;
            }
            绘制["damage_summary_line_1"] = { type: "text", visible: false, shadow: false };
            绘制["damage_summary_line_2"] = { type: "text", visible: false, shadow: false };
            绘制["damage_summary_line_3"] = { type: "text", visible: false, shadow: false };
            绘制["damage_summary_line_4"] = { type: "text", visible: false, shadow: false };
            for (let k = 0; k < 行文本数组.length && k < 4; k++) {
                let 当前行纯净文本 = (行文本数组[k] || "").replace(/§[0-9a-fk-or]/ig, "");
                if (当前行纯净文本.trim() === "") continue;
                let 当前行Y = 信息Y坐标 - ((有效行数 - 1 - k) * 行高偏移);
                绘制['damage_summary_line_' + (k + 1)] = {
                    type: "text", text: 当前行纯净文本, visible: true,
                    alignX: "right", alignY: "bottom",
                    x: 信息X坐标, y: 当前行Y,
                    scale: 文本缩放, color: 结算颜色表[k] || "#FFFFFF", shadow: true, draw: "ingame"
                };
            }
        } else if (消息类型 === "summary_clear") {
            绘制["damage_summary_line_1"] = { type: "text", visible: false, shadow: false };
            绘制["damage_summary_line_2"] = { type: "text", visible: false, shadow: false };
            绘制["damage_summary_line_3"] = { type: "text", visible: false, shadow: false };
            绘制["damage_summary_line_4"] = { type: "text", visible: false, shadow: false };
        }

        if (Object.keys(绘制).length > 0) {
            目标p.paint(绘制);
        }
    }
};

let 处理最终伤害统计数据 = (会话主键) => {
    let 会话数据 = 全局会话数据[会话主键];
    if (!会话数据) return;

    if (会话数据.秒伤计划任务 && typeof 会话数据.秒伤计划任务.clear === "function") {
        会话数据.秒伤计划任务.clear();
        会话数据.秒伤计划任务 = null;
    }
    信息(会话主键, "", "dps_clear");

    if (会话数据.最终统计清除任务 && typeof 会话数据.最终统计清除任务.clear === "function") {
        会话数据.最终统计清除任务.clear();
        会话数据.最终统计清除任务 = null;
    }

    let 结算行文本数组 = ["", "", "", ""];
    let 伤害来源显示 = "未知来源";
    let 伤害类型显示 = (会话数据.假人会话 && 会话数据.锁定攻击者信息) ? (会话数据.锁定攻击者信息.原始伤害类型 || "未知") : (会话数据.最近伤害类型 || "未知");

    if (会话数据.假人会话 && 会话数据.锁定攻击者信息) {
        伤害来源显示 = 会话数据.锁定攻击者信息.显示名称 || "实体";
    } else if (!会话数据.假人会话) {
        let 攻击p = Utils.server.getPlayer(会话主键);
        if (攻击p) 伤害来源显示 = 攻击p.name.string;
    }
    结算行文本数组[0] = "伤害类型:(" + 伤害类型显示 + "), 来自 " + 伤害来源显示;

    let 总伤害文本 = "总伤:" + (会话数据.累计伤害 || 0).toFixed(1);
    let 平均秒伤显示文本 = "均DPS:---";
    let 攻击持续总刻数 = 会话数据.最近命中时刻 - 会话数据.攻击开始时刻;
    let 攻击持续秒数 = 攻击持续总刻数 / 20.0;
    if (攻击持续秒数 >= 0.05) {
        let 计算得到的平均秒伤 = (会话数据.累计伤害 > 0 && 攻击持续秒数 > 0) ? (会话数据.累计伤害 / 攻击持续秒数) : 0;
        平均秒伤显示文本 = "均DPS:" + 计算得到的平均秒伤.toFixed(1);
    } else {
        平均秒伤显示文本 = (会话数据.累计伤害 > 0) ? "总伤:" + (会话数据.累计伤害).toFixed(1) + " (单次)" : "均DPS:0.0";
    }
    结算行文本数组[1] = 总伤害文本 + ", " + 平均秒伤显示文本;
    if (平均秒伤显示文本.indexOf("(单次)") !== -1) 结算行文本数组[1] = 平均秒伤显示文本;

    let 受击实体 = 实体(会话数据.维度ID, 会话数据.假人会话 ? 会话主键 : 会话数据.首次攻击目标UUID);
    let 目标显示名称 = (受击实体 && 受击实体.displayName && 受击实体.displayName.string) ? 受击实体.displayName.string : (会话数据.记录目标名称 || "未知目标");
    let 持续时间显示 = 攻击持续秒数 > 0.01 ? 攻击持续秒数.toFixed(1) + "秒" : "瞬时";
    结算行文本数组[2] = 目标显示名称 + ", 持续:" + 持续时间显示;
    let 最大HP文本 = (typeof 会话数据.记录的最大生命值 === "number") ? 会话数据.记录的最大生命值.toFixed(1) : "?";
    let 血量文本 = "目标消失/MAX:" + 最大HP文本;
    if (受击实体 && typeof 受击实体.isLiving === "function" && 受击实体.isLiving()) {
        血量文本 = "当前HP:" + (受击实体.health || 0).toFixed(1) + "/MAX:" + 最大HP文本;
    }
    结算行文本数组[3] = 血量文本;
    信息(会话主键, 结算行文本数组, "summary");
    会话数据.最终统计清除任务 = Utils.server.scheduleInTicks(100, () => {
        信息(会话主键, [], "summary_clear");
    });
    delete 全局会话数据[会话主键];
};

let 调度实时秒伤更新任务 = (会话主键) => {
    let 外部会话数据 = 全局会话数据[会话主键];
    if (!外部会话数据) return;

    if (外部会话数据.秒伤计划任务 && typeof 外部会话数据.秒伤计划任务.clear === "function") {
        外部会话数据.秒伤计划任务.clear();
        外部会话数据.秒伤计划任务 = null;
    }

    let 秒伤处理函数 = () => {
        let 循环内会话数据 = 全局会话数据[会话主键];

        if (!循环内会话数据 || !Utils.server || Utils.server.isStopped()) {
            信息(会话主键, "", "dps_clear");
            return;
        }

        let 累计伤害 = 循环内会话数据.本次N刻伤害 || 0;
        if (累计伤害 > 0) {
            let 计算秒伤值 = 累计伤害 / 1.0;
            let 秒伤消息内容 = "秒伤:" + 计算秒伤值.toFixed(1);
            if (循环内会话数据.假人会话 && 循环内会话数据.锁定攻击者信息) {
                秒伤消息内容 += " (来自:" + (循环内会话数据.锁定攻击者信息.显示名称 || "未知攻击者") + ")";
            }
            信息(会话主键, Text.of(秒伤消息内容), "dps");
        } else {
            信息(会话主键, "", "dps_clear");
        }

        循环内会话数据.本次N刻伤害 = 0;

        if (全局会话数据[会话主键]) {
            全局会话数据[会话主键].秒伤计划任务 = Utils.server.scheduleInTicks(20, 秒伤处理函数);
        } else {
            信息(会话主键, "", "dps_clear");
        }
    };

    if (Utils.server && typeof Utils.server.scheduleInTicks === "function") {
        外部会话数据.秒伤计划任务 = Utils.server.scheduleInTicks(20, 秒伤处理函数);
    }
};

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingDamageEvent"), e => {
    if (!e || !e.source || !e.entity) return;

    let 受击实体 = e.entity;
    let 假人 = !!(受击实体.persistentData && typeof 受击实体.persistentData.getBoolean === "function" && 受击实体.persistentData.getBoolean("IsTestDummy"));
    
    if (typeof e.amount !== "number" || isNaN(e.amount) || e.amount <= 0) {
        if (假人) {
            e.setCanceled(true);
            e.setAmount(0);
        }
        return;
    }

    let 本次事件玩家 = null;
    let 原始伤害源实体 = e.source.getActual();
    if (原始伤害源实体) {
        if (typeof 原始伤害源实体.isPlayer === "function" && 原始伤害源实体.isPlayer()) {
            本次事件玩家 = 原始伤害源实体;
        } else if (typeof 原始伤害源实体.getOwner === "function") {
            let 所有者 = 原始伤害源实体.getOwner();
            if (所有者 && typeof 所有者.isPlayer === "function" && 所有者.isPlayer()) {
                本次事件玩家 = 所有者;
            }
        }
    }
    
    if (!假人 && (!本次事件玩家 || (typeof 本次事件玩家.isFake === "function" && 本次事件玩家.isFake()))) {
        return;
    }

    let 会话主键 = null;
    if (假人) {
        会话主键 = 受击实体.stringUuid;
    } else {
        if (开关状态(本次事件玩家)) {
            会话主键 = 本次事件玩家.uuid.toString();
        } else {
            return;
        }
    }

    if (!会话主键) {
        if (假人) { e.setCanceled(true); e.setAmount(0); }
        return;
    }

    let 当前刻 = 受击实体.level.getTime();
    let 会话数据 = 全局会话数据[会话主键];
    let 开启新会话 = false;

    if (!会话数据) {
        开启新会话 = true;
    } else {
        if (当前刻 > 会话数据.锁定到期时刻) {
            开启新会话 = true;
        } else if (假人) {
            let 当前攻击者类型 = 本次事件玩家 ? "玩家" : (原始伤害源实体 ? "实体" : "环境");
            let 当前攻击者UUID = 本次事件玩家 ? 本次事件玩家.uuid.toString() : (原始伤害源实体 ? 原始伤害源实体.stringUuid : null);
            if (当前攻击者类型 !== 会话数据.锁定攻击者信息.类型 || 当前攻击者UUID !== 会话数据.锁定攻击者信息.UUID) {
                开启新会话 = true;
            }
        } else {
            if (受击实体.stringUuid !== 会话数据.首次攻击目标UUID) {
                开启新会话 = true;
            } else {
                let 锁定的目标实体 = 实体(会话数据.维度ID, 会话数据.首次攻击目标UUID);
                if (!锁定的目标实体 || (typeof 锁定的目标实体.isLiving === "function" && !锁定的目标实体.isLiving())) {
                    开启新会话 = true;
                }
            }
        }
    }

    if (开启新会话) {
        if (会话数据) {
            if (会话数据.最终统计 && typeof 会话数据.最终统计.clear === "function") 会话数据.最终统计.clear();
            if (会话数据.秒伤计划任务 && typeof 会话数据.秒伤计划任务.clear === "function") {
                会话数据.秒伤计划任务.clear();
                信息(会话主键, "", "dps_clear");
            }
            if (会话数据.最终统计清除任务 && typeof 会话数据.最终统计清除任务.clear === "function") {
                会话数据.最终统计清除任务.clear();
            }
            if (会话数据.累计伤害 > 0) 处理最终伤害统计数据(会话主键);
            else delete 全局会话数据[会话主键];
        }
        
        let 本次伤害类型 = (e.source && typeof e.source.getType === "function") ? e.source.getType() : "未知";
        let 新会话数据 = {
            累计伤害: 0, 攻击开始时刻: 当前刻, 最近命中时刻: 当前刻, 本次N刻伤害: 0,
            最终统计: null, 秒伤计划任务: null, 最终统计清除任务: null,
            锁定到期时刻: 当前刻 + 会话超时时间_刻*20,
            假人会话: 假人
        };

        if (假人) {
            新会话数据.维度ID = 受击实体.level.dimension.toString();
            let 锁定攻击者类型 = "未知", 锁定攻击者UUID = null, 锁定攻击者显示名称 = "未知来源";
            if (本次事件玩家) {
                锁定攻击者类型 = "玩家"; 锁定攻击者UUID = 本次事件玩家.uuid.toString(); 锁定攻击者显示名称 = 本次事件玩家.name.string;
            } else if (原始伤害源实体) {
                锁定攻击者类型 = "实体"; 锁定攻击者UUID = 原始伤害源实体.stringUuid; 锁定攻击者显示名称 = (原始伤害源实体.displayName && 原始伤害源实体.displayName.string) || 原始伤害源实体.type;
            } else {
                锁定攻击者类型 = "环境"; 锁定攻击者显示名称 = 本次伤害类型;
            }
            新会话数据.锁定攻击者信息 = { 类型: 锁定攻击者类型, UUID: 锁定攻击者UUID, 显示名称: 锁定攻击者显示名称, 原始伤害类型: 本次伤害类型 };
            新会话数据.记录目标名称 = (受击实体.displayName && 受击实体.displayName.string) || "测试假人";
            新会话数据.记录的最大生命值 = (typeof 受击实体.getMaxHealth === "function") ? 受击实体.getMaxHealth() : 受击实体.maxHealth;
        } else {
            新会话数据.首次攻击目标UUID = 受击实体.stringUuid;
            新会话数据.记录目标名称 = (受击实体.displayName && 受击实体.displayName.string) || 受击实体.type;
            新会话数据.记录的最大生命值 = (typeof 受击实体.getMaxHealth === "function") ? 受击实体.getMaxHealth() : 受击实体.maxHealth;
            新会话数据.维度ID = 本次事件玩家.level ? 本次事件玩家.level.dimension.toString() : null;
            新会话数据.最近伤害类型 = 本次伤害类型;
            新会话数据.记录攻击者显示名称 = 本次事件玩家.name.string;
        }
        
        全局会话数据[会话主键] = 新会话数据;
        调度实时秒伤更新任务(会话主键);
    }
    
    会话数据 = 全局会话数据[会话主键];
    let 计入此伤害 = false;
    if (会话数据) {
        if (!会话数据.假人会话) {
            if (受击实体.stringUuid === 会话数据.首次攻击目标UUID) 计入此伤害 = true;
        } else {
             let 当前攻击者类型 = 本次事件玩家 ? "玩家" : (原始伤害源实体 ? "实体" : "环境");
             let 当前攻击者UUID = 本次事件玩家 ? 本次事件玩家.uuid.toString() : (原始伤害源实体 ? 原始伤害源实体.stringUuid : null);
             if (当前攻击者类型 === 会话数据.锁定攻击者信息.类型 && 当前攻击者UUID === 会话数据.锁定攻击者信息.UUID) {
                计入此伤害 = true;
             }
        }
    }

    if (计入此伤害) {
        会话数据.累计伤害 += e.amount;
        会话数据.本次N刻伤害 += e.amount;
        会话数据.最近命中时刻 = 当前刻;
        会话数据.锁定到期时刻 = 当前刻 + 会话超时时间_刻*20;
        if (!会话数据.假人会话) {
             会话数据.最近伤害类型 = (e.source && typeof e.source.getType === "function") ? e.source.getType() : "未知";
        }
        if (会话数据.最终统计 && typeof 会话数据.最终统计.clear === "function") {
            会话数据.最终统计.clear();
        }
        会话数据.最终统计 = Utils.server.scheduleInTicks(会话超时时间_刻*20, () => {
            let 任务时会话数据 = 全局会话数据[会话主键];
            if (任务时会话数据 && 任务时会话数据.最近命中时刻 === 会话数据.最近命中时刻) {
                处理最终伤害统计数据(会话主键);
            }
        });
    }

    if (假人) {
        e.setAmount(0);
        e.setCanceled(true);
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingDeathEvent"), e => {
    if (!e || !e.entity) return;

    let 死亡实体 = e.entity;

    if (死亡实体.persistentData && typeof 死亡实体.persistentData.getBoolean === "function" && 死亡实体.persistentData.getBoolean("IsTestDummy")) {
        if (伤害统计调试开关) {
            console.log(`[假人保险] 检测到测试假人 "${死亡实体.displayName.string}" 尝试死亡, 正在进行豁免...`);
            console.log(`[假人保险] -> 伤害来源: ${e.source}`);
            console.log(`[假人保险] -> 当前生命值: ${死亡实体.health}`);
        }

        e.setCanceled(true);
        
        if (typeof 死亡实体.getMaxHealth === "function" && typeof 死亡实体.setHealth === "function") {
            死亡实体.setHealth(死亡实体.getMaxHealth());
            if (伤害统计调试开关) {
                console.log(`[假人保险] -> 已将生命值恢复到: ${死亡实体.getMaxHealth()}`);
            }
        }
    }
});
